/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package console;

import console.*;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class ConsoleExample {
    
    public static void prompt(String prompt) {
        //Navigate to source to see what really happens when you print out a message.
        System.out.println(prompt);
    }
    
    public static String accept(){
        byte[] bytes= new byte[10];
        char[] chars=new char[10];
        String str="";
        try {
            System.in.read(bytes);
            for (byte b: bytes){
            System.out.print(b);
            }
            System.out.println();
            
            //Modify to work with characters
//            System.in.read(chars);//Doesn't work as System.in is InputStream and works with bytes.
            //Build an InputStreamReader to work with chars
//            InputStreamReader input = new InputStreamReader(System.in);
//            input.read(chars);
//            System.out.print(chars);
            //Modify to work with strings
//            input.read(str);//Doesn't work as inputStreamReader deals with individual chars.
//            BufferedReader stringInput = new BufferedReader(input);
//            str=stringInput.readLine();//Use readLine method to read whole lines.
//            System.out.println(str);
            
        } catch (IOException ex) {
            Logger.getLogger(ConsoleExample.class.getName()).log(Level.SEVERE, null, ex);
        }

        return str;
    }
    
}
